/* Copyright (c) 2008, Oracle. All rights reserved. */

import java.io.*;

public class LASPointDataRecordFormat1 extends LASPointDataRecord {
	byte[] gpsTime = new byte[8];
        byte[] extraData; // ?

	public LASPointDataRecordFormat1() {
	  super();
	}

	public void parse(InputStream inputStream, int pointDataRecordLength) {
	  super.parse(inputStream,pointDataRecordLength);
	  try {
	    inputStream.read(gpsTime);
	    int bytesRemaining = pointDataRecordLength-28;
	    extraData = new byte[bytesRemaining];
	    inputStream.read(extraData);
	  }
          catch(IOException exception) {
    	    exception.printStackTrace();
	  }
	}

	public void write(OutputStream outputStream, int pointDataRecordLength) {
	  super.write(outputStream,pointDataRecordLength);

	  try {
	    outputStream.write(gpsTime);
	    //int bytesRemaining=pointDataRecordLength-28;
	    //extraData=new byte[bytesRemaining];
	    if ((extraData != null) && (extraData.length != 0)){
	      outputStream.write(extraData);
	    }
	  }
          catch(IOException exception) {
	    exception.printStackTrace();
	  }
	}

	public double getGPSTime() {
	  return littleEndianArray8ToDouble(gpsTime);
	}

	public void putGPSTime(double gpsTime) {
	  this.gpsTime=doubleToLittleEndianArray8(gpsTime);
	}


	public void print() {
	  super.print();
          //System.out.println("gpsTime "+getGPSTime());
          //System.out.println("extra data: "+arrayToBits(extraData));
	}

}
